#ifndef Trie_HPP
#define Trie_HPP

#include "common.hpp"
#include <vector>
#include <set>

using namespace std;

class ATrie;
class Trie;

struct Edge
{
   itemtype label;
   Trie* subtrie;
};

class Trie
{
friend class ATrie;

public:

   Trie( const countertype init_counter ):counter(init_counter){}

   /// It decides whether the given itemset is included in the trie or not.
   const Trie* is_included( const set<itemtype>& an_itemset, 
			    set<itemtype>::const_iterator item_it ) const;

   /// Increases the counter for those itemsets that is 
   /// contained by the given basket.
   void find_candidate( vector<itemtype>::const_iterator it_basket_upper_bound,
			   vector<itemtype>::const_iterator it_basket, 
			const countertype counter_incr );

   /// Deletes the tries that represent infrequent itemsets.
   void delete_infrequent( const double min_occurrence );

   ~Trie();

private:

   /// Adds an empty state to the trie
   void add_empty_state( const itemtype item, 
			 const countertype init_counter=0 );

public:
   // No public members

private:

   /// counter stores the occurrence of the itemset represented by the Trie
   countertype counter;

   vector<Edge> edgevector;
   
};


#endif
